
require('sketchup.rb')
require('extensions.rb')
require('LangHandler.rb')
require('Phlatboyz/Observers.rb')

module PhlatScript

  @@AppChangeObserver = AppChangeObserver.new
  @@ModelChangeObserver = ModelChangeObserver.new
  @@phlatboyzStrings = LanguageHandler.new("PhlatBoyz.strings")
  @@phlatboyz_tools_submenu = nil
  @@Loaded = false
  @@tools = []
  @@cuts = []

  Sketchup.add_observer(@@AppChangeObserver)

  def PhlatScript.setModelOptions(model)
  	renderingoptions = model.rendering_options
  	renderingoptions["EdgeColorMode"] = $rendering_edge_color_mode

    model.add_observer(@@ModelChangeObserver)

    # Define "Hole" material
    m = model.materials.add "Hole"
    m.alpha = 0.5
    m.color = "white"
  end

  def PhlatScript.doSave(model)
		set_model_options(model)
  end

  def PhlatScript.getString(s)
    @@phlatboyzStrings.GetString(s)
  end

  def PhlatScript.load
    return if @@Loaded
    loadTools
  	UI.add_context_menu_handler do | menu | contextMenuHandler(menu) end
    setModelOptions(Sketchup.active_model)
    @@Loaded = true
  end

  def PhlatScript.contextMenuHandler(menu)
    submenu = menu.add_submenu(PhlatScript.getString("Phlat Edge"))
    @@tools.each { |tool|
      # don't process the tool if it doesn't advertise context menus
      next if ((tool.tooltype & PB_MENU_CONTEXT) != PB_MENU_CONTEXT)
      items = tool.getContextMenuItems
      next if !items
      items = [items] if (!items.kind_of?(Array))
      return if (items.length < 0)
      items.each { |item|
        if item.to_s.eql? '--'
          submenu.add_separator
        else
          submenu.add_item(PhlatScript.getString(item.to_s)) { tool.onContextMenu(item.to_s) }
        end
      }
    }
  end

  def PhlatScript.get_fold_depth_factor(model=Sketchup.active_model)
    return model.get_attribute($dict_name, $dict_fold_depth_factor, $default_fold_depth_factor)
  end

  def PhlatScript.set_fold_depth_factor(in_factor, model=Sketchup.active_model)
    f = in_factor % 1000
    f = 110 if f > 110
    model.set_attribute $dict_name, $dict_fold_depth_factor, f
  end

  def PhlatScript.display_fold_depth_factor
    Sketchup::set_status_text "depth percent", SB_VCB_LABEL
    Sketchup::set_status_text getString("depth percent"), SB_VCB_LABEL
    fold_factor = get_fold_depth_factor()
    Sketchup::set_status_text fold_factor.to_s, SB_VCB_VALUE
  end

  def PhlatScript.tools
    @@tools
  end

  def PhlatScript.cuts
    @@cuts
  end

  def PhlatScript.cncFileName
    model=Sketchup.active_model
    begin
      path = model.path
      if path && path.length > 0
        path.match(/([a-zA-Z0-9\s]*)\.skp$/)
        default_filename = $1+".cnc"
      else
        default_filename = $default_file_name
      end
    rescue
      UI.messagebox "Exception in PhlatboyzMethods.get_model_filename_or_default() "+$!
    end
    filename = model.get_attribute($dict_name, $dict_output_file_name, default_filename)
    filename = (filename == $default_file_name) ? default_filename : filename
    #UI.messagebox("default_filename: #{default_filename} filename: #{filename}")
    return filename
  end

  def PhlatScript.cncFileName=(filename)
    Sketchup.active_model.set_attribute($dict_name, $dict_output_file_name, filename)
  end

  def PhlatScript.cncFileDir
    return Sketchup.active_model.get_attribute($dict_name, $dict_output_directory_name, $default_directory_name)
  end

  def PhlatScript.cncFileDir=(dir)
    output_directory_name = Sketchup.active_model.set_attribute $dict_name, $dict_output_directory_name, dir
  end

  def PhlatScript.cncFile=(full_filename)
    begin
      file_basename = nil
      file_dirname = nil
      status = (full_filename != nil)
      if(status)
        file_basename = File.basename(full_filename)
        status = Sketchup.is_valid_filename?(file_basename)
        if(status)
          file_dirname = File.dirname(full_filename)
          status = File.directory?(file_dirname)
        end
      end
      if(status)
        result_array = Array.new
        self.cncFileDir = file_dirname + File::SEPARATOR
        self.cncFileName = file_basename
      else
        UI.messagebox($phlatboyzStrings.GetString("Filename Error") + ": " + ((full_filename == nil) ? "nil" : full_filename))
      end
    rescue
      UI.messagebox "Exception retrieving GCode file name "+$!
      nil
    end
  end

  private

  def PhlatScript.loadTools
    @@commandToolbar = UI::Toolbar.new(getString("Phlatboyz"))
    add_separator_to_menu("Tools")
    @@phlatboyz_tools_submenu = UI.menu("Tools").add_submenu(getString("Phlatboyz"))

    require 'Phlatboyz/tools/ParametersTool.rb'
    addToolItem(ParametersTool.new())
  	@@phlatboyz_tools_submenu.add_separator

    require 'Phlatboyz/tools/CutTool.rb'
    addToolItem(OutsideCutTool.new)
    addToolItem(InsideCutTool.new)

    require 'Phlatboyz/tools/TabTool.rb'
    addToolItem(TabTool.new())

    require 'Phlatboyz/tools/FoldTool.rb'
    addToolItem(FoldTool.new())

    require 'Phlatboyz/tools/PlungeTool.rb'
    addToolItem(PlungeTool.new())

    require 'Phlatboyz/tools/CenterLineTool.rb'
    addToolItem(CenterLineTool.new())

    require 'Phlatboyz/tools/EraseTool.rb'
    addToolItem(EraseTool.new())

    require 'Phlatboyz/tools/PhlattenTool.rb'
    addToolItem(PhlattenTool.new())

    require 'Phlatboyz/tools/SafeTool.rb'
    addToolItem(SafeTool.new())

    require 'Phlatboyz/tools/GcodeUtil.rb'
    addToolItem(GcodeUtil.new())

  	@@phlatboyz_tools_submenu.add_separator
    require 'Phlatboyz/tools/HomepageTool.rb'
    addToolItem(HomepageTool.new())

    require 'Phlatboyz/tools/HelpTool.rb'
    addToolItem(HelpTool.new())

#    require 'Phlatboyz/tools/TestTool.rb'
#    addToolItem(TestTool.new())
  end

  def PhlatScript.addToolItem(tool)
    cmd = UI::Command.new(tool.menuItem) { tool.select }
    cmd.large_icon = tool.largeIcon
    cmd.small_icon = tool.smallIcon
    cmd.tooltip = tool.tooltip
    cmd.status_bar_text = tool.statusText 
    cmd.menu_text = tool.menuText
    @@phlatboyz_tools_submenu.add_item(cmd) if ((tool.tooltype & PB_MENU_MENU) == PB_MENU_MENU)
    @@commandToolbar.add_item(cmd) if ((tool.tooltype & PB_MENU_TOOLBAR) == PB_MENU_TOOLBAR)
    @@tools.push(tool)
    @@cuts.push(tool.cut_class) if tool.cut_class
  end

end
